<?php

/**
 * Stub that simulates output from 'grep IP /var/log/nginx/modsec_audit.log'
 *
 * This stub shows:
 * 1. ModSecurity v3 with nginx connector JSON format
 * 2. Blocked attempts with rule details
 * 3. Structured data for easy parsing
 *
 * Simulated command: grep {TARGET_IP} /var/log/nginx/modsec_audit.log
 */

return [
    'nginx_modsec_audit' => <<<'EOD'
{"transaction":{"client_ip":"{TARGET_IP}","time_stamp":"Fri Jun 13 00:30:45 2025","server_id":"a8616bf70d357408b89b11703d8608db52fc1e56","client_port":60743,"host_ip":"5.135.93.75","host_port":443,"unique_id":"174976744588.826158","request":{"method":"GET","http_version":1.1,"uri":"/wp-config.php.bkp","body":"","headers":{"Host":"fontaneriafontcal.com","User-Agent":"Mozilla/5.0 (Windows NT 10.0; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0","Accept":"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8","Accept-Language":"en-US,en;q=0.5","Accept-Encoding":"gzip, deflate"}},"response":{"http_code":404,"headers":{"Server":"nginx","Date":"Thu, 12 Jun 2025 22:30:46 GMT","Content-Length":"22255","Expires":"Wed, 11 Jan 1984 05:00:00 GMT","Content-Type":"text/html; charset=UTF-8","Connection":"keep-alive","Cache-Control":"no-cache, must-revalidate, max-age=0, no-store, private","Link":"<https://fontaneriafontcal.com/wp-json/>; rel=\"https://api.w.org/\"","Set-Cookie":"wpr_guest_token=548d8d7bcaa5dbb8efd798637b6619160ccf0ff5beafd7a9b7c6d141dbc6488d; expires=Thu, 12 Jun 2025 23:30:46 GMT; Max-Age=3600; path=/; secure; HttpOnly","Vary":"Accept-Encoding,User-Agent","Content-Encoding":"gzip"}},"producer":{"modsecurity":"ModSecurity v3.0.14 (Linux)","connector":"ModSecurity-nginx v1.0.4","secrules_engine":"Enabled","components":["OWASP_CRS/4.15.0\""]},"messages":[{"message":"Restricted File Access Attempt","details":{"match":"Matched \"Operator `PmFromFile' with parameter `restricted-files.data' against variable `REQUEST_FILENAME' (Value: `/wp-config.php.bkp' )","reference":"o1,13v4,18t:utf8toUnicode,t:urlDecodeUni,t:normalizePathWin","ruleId":"930130","file":"/etc/modsecurity.d/REQUEST-930-APPLICATION-ATTACK-LFI.conf","lineNumber":"127","data":"Matched Data: wp-config.php found within REQUEST_FILENAME: /wp-config.php.bkp","severity":"2","ver":"OWASP_CRS/4.15.0","rev":"","tags":["application-multi","language-multi","platform-multi","attack-lfi","paranoia-level/1","OWASP_CRS","OWASP_CRS/ATTACK-LFI","capec/1000/255/153/126","PCI/6.5.4"],"maturity":"0","accuracy":"0"}}]}}
{"transaction":{"client_ip":"{TARGET_IP}","time_stamp":"Fri Jun 13 00:30:46 2025","server_id":"a8616bf70d357408b89b11703d8608db52fc1e56","client_port":60743,"host_ip":"5.135.93.75","host_port":443,"unique_id":"174976744658.073489","request":{"method":"POST","http_version":1.1,"uri":"/wp-login.php","body":"log=admin&pwd=password123&wp-submit=Log+In","headers":{"Host":"fontaneriafontcal.com","User-Agent":"Mozilla/5.0 (Windows NT 10.0; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0","Accept":"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8","Accept-Language":"en-US,en;q=0.5","Accept-Encoding":"gzip, deflate","Content-Type":"application/x-www-form-urlencoded","Content-Length":"45"}},"response":{"http_code":403,"headers":{"Server":"nginx","Date":"Thu, 12 Jun 2025 22:30:47 GMT","Content-Length":"289","Content-Type":"text/html; charset=UTF-8","Connection":"keep-alive"}},"producer":{"modsecurity":"ModSecurity v3.0.14 (Linux)","connector":"ModSecurity-nginx v1.0.4","secrules_engine":"Enabled","components":["OWASP_CRS/4.15.0\""]},"messages":[{"message":"Host header is a numeric IP address","details":{"match":"Matched \"Operator `Rx' with parameter `^[\\\\d.:]+$' against variable `REQUEST_HEADERS:Host' (Value: `{TARGET_IP}' )","reference":"t:none","ruleId":"960017","file":"/etc/modsecurity.d/REQUEST-921-PROTOCOL-ATTACK.conf","lineNumber":"47","data":"Matched Data: {TARGET_IP} found within REQUEST_HEADERS:Host: {TARGET_IP}","severity":"4","ver":"OWASP_CRS/4.15.0","rev":"1","tags":["application-multi","language-multi","platform-multi","attack-protocol","OWASP_CRS","OWASP_CRS/PROTOCOL-ATTACK","capec/1000/210/272"],"maturity":"9","accuracy":"9"}}]}}
EOD,
];
