<?php

namespace App\Filament\Resources\HostResource\Pages;

use App\Filament\Actions\GenerateSshKeysAction;
use App\Filament\Resources\HostResource;
use Filament\Actions\DeleteAction;
use Filament\Resources\Pages\EditRecord;

class EditHost extends EditRecord
{
    protected static string $resource = HostResource::class;

    protected function getHeaderActions(): array
    {
        return [
            GenerateSshKeysAction::make(),
            DeleteAction::make(),
        ];
    }

    protected function mutateFormDataBeforeFill(array $data): array
    {
        // Make SSH keys visible for Filament forms
        $record = $this->getRecord();
        $data['hash'] = $record->hash;
        $data['hash_public'] = $record->hash_public;

        return $data;
    }
}
