# Description

<!-- Provide a brief description of the changes in this PR -->

## Type of Change

<!-- Mark the relevant option with an "x" -->

- [ ] 🐛 Bug fix (non-breaking change that fixes an issue)
- [ ] ✨ New feature (non-breaking change that adds functionality)
- [ ] 💥 Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] 📚 Documentation update
- [ ] 🔧 Configuration change
- [ ] ♻️ Code refactoring
- [ ] ⚡ Performance improvement
- [ ] ✅ Test addition or update

## Related Issue

<!-- If this PR fixes an issue, link it here -->

Fixes #(issue number)

## Changes Made

<!-- List the main changes made in this PR -->

- 
- 
- 

## Testing

<!-- Describe the tests you ran and how to reproduce them -->

### Test Configuration

- PHP version:
- Laravel version:
- Database:
- Panel type (if applicable):

### Test Steps

1. 
2. 
3. 

## Checklist

<!-- Mark completed items with an "x" -->

- [ ] My code follows the project's code style (Laravel Pint)
- [ ] I have performed a self-review of my code
- [ ] I have commented my code, particularly in hard-to-understand areas
- [ ] I have made corresponding changes to the documentation
- [ ] My changes generate no new warnings or errors
- [ ] I have added tests that prove my fix is effective or that my feature works
- [ ] New and existing unit tests pass locally with my changes (`php artisan test`)
- [ ] I have checked my code with PHPStan (`./vendor/bin/phpstan analyse`)
- [ ] I have sanitized any sensitive information (no passwords, real IPs, or domains)

## Screenshots (if applicable)

<!-- Add screenshots to help explain your changes -->

## Additional Notes

<!-- Any additional information that reviewers should know -->

